*! version 5.0
* 13 August 2018
* NIDS
* Coding employment status

*====================================================================================================================================

* NOTE		

/*

The following variables were used in the original do-file, they are listed with their variable name which is consistent across waves
as well as the corresponding question number in each wave. 

variable name		w1				w2             w3				w4				w5
em1 			->	e1			->	e2         ->  e2			->	eb1			->	eb1
em2				->	e18			->	e23        ->  e23			->	eb16		->	eb16
ems				->	e28			->	e33        ->  e33			->	ec1			->	ec1
emc				->	e40			->	e48        ->  e48			->	ed1			->	ed1
emp				->	e45			->	e53        ->  e53			->	ee1			->	ee1
emh				->	e52			->	e61        ->  e61			->	ef1			->	ef1
unemwnt			->	e66			->	e74        ->  e74			->	eg6			->	eg6
unems*			->	e71_1a 		->	e79*       ->  e79*			->	eg11*		->	eg11*

*/

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

global DataIN "C:\Users\Admin\Desktop\W5"    			//File path to where data is located. Change this path according to where your data folder in located on your computer.
global DataOUT "C:\Users\Admin\Desktop\W5"

global temp "C:\Users\Admin\Desktop\W5"					// tempfile to hold all the working datasets, all working datasets will
														// be deleted from this folder at the completion of the do file execution.
global VersionIN "W5_Anon_V1.0.0.dta"
global VersionOUT "Derived"																

version 12.0											// version of Stata being used, this is needed for the rename command.

set more off
*=====================================================================================================================================================

* ADULT

use "$DataIN\Adult_$VersionIN", clear

cap rename w5_a_* *

gen done_nothing = 1 if unems1 == 11

gen Employed= (em1==1|em2==1|ems==1|emc==1|emp==1|emh==1)
gen Not_economically_active= (Employed==0 & unemwnt==2)
gen Unemployed_discouraged= (Employed==0 & unemwnt==1 & done_nothing == 1)
gen Unemployed_strict= (Employed==0 & unemwnt==1 & done_nothing != 1)

gen state=.
replace state=0 if Not_economically_active==1
replace state=1 if Unemployed_discouraged==1
replace state=2 if Unemployed_strict==1
replace state=3 if Employed==1
replace state=-8 if state == . & outcome == 1

replace state=. if outcome != 1

la def state 0"Not Economically Active" 1"Unemployed_Discouraged" 2"Unemployed_Strict" 3"Employed" -8"Refused"
la val state state

ren state state_fine_a

gen state2=0 if state_fine_a == 0
replace state2=1 if state_fine_a >=1 & state_fine_a <=2
replace state2=2 if state_fine_a ==3
replace state2=-8 if state_fine_a == -8
la def state2 0"Not Economically Active" 1"Unemployed" 2"Employed" -8"Refused"
la val state2 state2

rename state2 state_coarse_a

keep pid w5_hhid state_fine_a  state_coarse_a

sort  pid

save "$temp\1_labour.dta", replace

* END OF USING THE ADULT

*=================================================================================================================================

* PROXY

use "$DataIN\Proxy_$VersionIN", clear

rename w5_p_* *
gen state=.
replace state=0 if emactcur>=5 & emactcur<=8
replace state=1 if emactcur==10
replace state=2 if emactcur==9
replace state=3 if emactcur>=1 & emactcur<=4
replace state=-8 if state == . & outcome == 1

replace state=. if outcome != 1
la def state 0"Not Economically Active" 1"Unemployed_Discouraged" 2"Unemployed_Strict" 3"Employed" -8"Refused"
la val state state

ren state state_fine_p

gen state2=0 if state_fine_p == 0
replace state2=1 if state_fine_p >=1 & state_fine_p <=2
replace state2=2 if state_fine_p ==3
replace state2=-8 if state_fine_p == -8

la def state2 0"Not Economically Active" 1"Unemployed" 2"Employed" -8"Refused"
la val state2 state2
ren state2  state_coarse_p

keep pid w5_hhid  state_fine_p  state_coarse_p
sort pid

save "$temp\2_labour.dta", replace

* END OF USING PROXY


*=================================================================================================================================

* INDDERIVED

use "$DataIN\indderived_$VersionIN", clear

drop w5_empl_stat

merge 1:1 pid w5_hhid using "$temp\1_labour.dta"
drop _merge

sort pid
merge 1:1 pid w5_hhid using "$temp\2_labour.dta"
drop _merge


gen state_fine_ap = .
replace state_fine_ap = state_fine_a if state_fine_a !=.
replace state_fine_ap = state_fine_p if state_fine_p !=.

gen state_coarse_ap = .
replace state_coarse_ap = state_coarse_a if state_coarse_a !=.
replace state_coarse_ap = state_coarse_p if state_coarse_p !=.

la val state_fine_ap state_fine_ap

la def state_coarse_ap 0"Not Economically Active" 1"Unemployed" 2"Employed" -8"Refused"
la val state_coarse_ap state_coarse_ap

ren state_coarse_ap w5_empl_stat_broad
ren state_fine_ap   w5_empl_stat_narrow

lab var w5_empl_stat_broad "Employment status - Broad definition"
lab var w5_empl_stat_narrow "Employment status - Narrow definition"

drop w5_empl_stat_broad
rename w5_empl_stat_narrow w5_empl_stat

lab var w5_empl_stat "Employment status - Adult and Proxy"

cap drop state_fine_a state_coarse_a state_fine_p state_coarse_p

duplicates drop pid, force
save "$DataOUT\indderived_EMPLOYMENT_STATUS.dta", replace

*=================================================================================================================================
